% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_prepare}
\alias{vd_prepare}
\title{Prepare choice data for analysis}
\usage{
vd_prepare(dt, Af = NULL)
}
\arguments{
\item{dt}{tidy choice data (columns: id, task, alt, x, p, attributes)}

\item{Af}{(optional) contains a full design matrix (for attribute-based screening), or, more generally, a design matrix used for attribute-based screening}
}
\value{
list containing information for estimation functions
}
\description{
This utility function prepares tidy choice data for fast MCMC samplers.
}
\details{
Note: This function is only exported because it makes it easier to tinker with this package.
This function re-arranges choice data for fast access in highly-optimized MCMC samplers.
It Pre-computes task-wise total expenditures \code{sumpsx} and generates indices \code{xfr},\code{xto},\code{lfr},\code{lto} for fast data access.
}
\examples{
#minimal data example
dt <- structure(list(id = c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 
                            2L, 2L), 
                     task = c(1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L), 
                     alt = c(1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L), 
                     x = c(1, 0, 2, 1, 0, 1, 2, 3, 1, 1, 0, 1), 
                     p = c(0, 1, 1, 1, 2, 0, 2, 2, 1, 2, 1, 1), 
                     attr2 = c(1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0), 
                     attr1 = c(0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1)), 
                 class = c("tbl_df", "tbl", "data.frame"), row.names = c(NA,-12L))
#run prep function
test <- dt \%>\% vd_prepare 

}
