## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")
options(tibble.print_min = 4L, tibble.print_max = 4L)

## ----setup--------------------------------------------------------------------
library(ecocomDP)

## ----eval=FALSE---------------------------------------------------------------
#  mypath <- paste0(tempdir(), "/dwca")
#  dir.create(mypath)
#  
#  convert_to_dwca(
#    path = mypath,
#    core_name = "event",
#    source_id = "edi.193.4",
#    derived_id = "edi.834.1",
#    user_id = "ecocomdp",
#    user_domain = "EDI")
#  #> Reading edi.193.4
#  #>  [0%] Downloaded 0 bytes...
#  #>  [0%] Downloaded 0 bytes...
#  #>  [0%] Downloaded 0 bytes...
#  #>  [0%] Downloaded 0 bytes...
#  #>  [0%] Downloaded 0 bytes...
#  #>  [0%] Downloaded 0 bytes...
#  #>  [0%] Downloaded 0 bytes...
#  #>  [0%] Downloaded 0 bytes...
#  #>
#  #> Validating edi.193.4:
#  #>   Required tables
#  #>   Column names
#  #>   Required columns
#  #>   Column classes
#  #>   Datetime formats
#  #>   Primary keys
#  #>   Composite keys
#  #>   Referential integrity
#  #>   Latitude and longitude format
#  #>   Latitude and longitude range
#  #>   Elevation
#  #>
#  #> Creating DwC-A Event Core tables
#  #> Creating DwC-A Event Core EML
#  #> Reading EML of L1 data package edi.193.4
#  #> Reading EML of L0 data package knb-lter-hfr.118.32
#  #> Creating EML of L2 data package edi.834.1
#  #> Updating:
#  #>   <eml>
#  #>   <access>
#  #>   <dataset>
#  #>   <alternateIdentifier>
#  #>   <title>
#  #>   <pubDate>
#  #>   <abstract>
#  #>   <keywordSet>
#  #>   <methods>
#  #>   <dataTable>
#  #>   <otherEntity>
#  #>   <annotations>
#  #>   </eml>
#  #>   Writing EML
#  #> Validating EML
#  #> Validation passed :)
#  #> Done.
#  

## ----eval=FALSE---------------------------------------------------------------
#  dir(mypath)
#  #> [1] "edi.834.1.xml"                 "event.csv"                     "extendedmeasurementorfact.csv"
#  #> [4] "meta.xml"                      "occurrence.csv"

