% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{canberra}
\alias{canberra}
\title{Canberra}
\usage{
canberra(counts, weighted = TRUE, pairs = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{weighted}{If \code{TRUE}, the algorithm takes relative abundances into
account. If \code{FALSE}, only presence/absence is considered.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Canberra beta diversity metric.
}
\section{Calculation}{


In the formulas below, \code{x} and \code{y} are two columns (samples) from \code{counts}.
\code{n} is the number of rows (OTUs) in \code{counts}.

OTUs must be removed if they are absent from both samples.

\deqn{D = \displaystyle \frac{1}{n}\sum_{i = 1}^{n} \frac{|x_i - y_i|}{x_i + y_i}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{  x <- c(4, 0, 3, 0, 6)[-4]
  y <- c(0, 8, 0, 0, 5)[-4]
  sum(abs(x-y) / (x+y)) / length(x)  
  #>  0.7727273
}\if{html}{\out{</div>}}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Gower weighted distance matrix
    canberra(ex_counts)
    
    # Gower unweighted distance matrix
    canberra(ex_counts, weighted = FALSE)
    
    # Only calculate distances for A vs all.
    canberra(ex_counts, pairs = 1:3)
    
}
\references{
Lance GN and Williams WT 1967.
A general theory of classificatory sorting strategies II. Clustering systems.
The computer journal, 10(3).
\doi{10.1093/comjnl/10.3.271}
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{euclidean}()},
\code{\link{generalized_unifrac}()},
\code{\link{gower}()},
\code{\link{jaccard}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
