% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefy.r
\name{rarefy}
\alias{rarefy}
\title{Rarefy OTU counts.}
\usage{
rarefy(
  counts,
  depth = 0.1,
  n_samples = NULL,
  seed = 0,
  times = NULL,
  cpus = n_cpus()
)
}
\arguments{
\item{counts}{A numeric matrix of count data where each column is a
feature, and each row is a sample. Any object coercible with
\code{as.matrix()} can be given here, as well as \code{phyloseq}, \code{rbiom},
\code{SummarizedExperiment}, and \code{TreeSummarizedExperiment} objects.}

\item{depth}{How many observations to keep per sample. When
\verb{0 < depth < 1}, it is taken as the minimum percentage of the
dataset's observations to keep. Ignored when \code{n_samples} is
specified. Default: \code{0.1}}

\item{n_samples}{The number of samples to keep. When \verb{0 < n_samples < 1},
it is taken as the percentage of samples to keep. If negative, that
number of samples is dropped. If \code{0}, all samples are kept.
If \code{NULL}, then \code{depth} is used instead. Default: \code{NULL}}

\item{seed}{An integer seed for randomizing which observations to keep or
drop. If you need to create different random rarefactions of the same
data, set the seed to a different number each time.}

\item{times}{How many independent rarefactions to perform. If set,
\code{rarefy()} will return a list of matrices. The seeds for each matrix
will be sequential, starting from \code{seed}.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
An integer matrix.
}
\description{
Sub-sample OTU observations such that all samples have an equal number.
If called on data with non-integer abundances, values will be re-scaled to
integers between 1 and \code{depth} such that they sum to \code{depth}.
}
\examples{
    # Create an OTU matrix with 4 samples (A-D) and 5 OTUs.
    counts <- matrix(
      data     = c(4,0,3,2,6,0,8,0,0,5,0,9,0,0,7,0,10,0,0,1),
      nrow     = 5,
      dimnames = list(paste0('OTU', 1:5), LETTERS[1:4]) )
    counts
    colSums(counts)
    
    counts <- rarefy(counts, depth = 14)
    counts
    colSums(counts)

}
