
test_that("output data frame expert pathway", {
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = ex_output_calc_sensitivity
  )
  expect_s3_class(dat, "data.frame")
  expect_equal(dim(dat), c(40, 6))
  expect_true(all(dat$pressure %in% ex_output_calc_exposure$pressure))
  expect_true(all(dat$indicator %in% ex_output_calc_sensitivity$indicator))

  expect_type(dat$pressure, "character")
  expect_type(dat$indicator, "character")
  expect_type(dat$type, "character")
  expect_type(dat$vulnerability, "double")
  expect_type(dat$uncertainty, "double")
})


test_that("output data frame model pathway", {
  dat <- vulnerability(
    exposure_results = ex_output_model_exposure,
    sensitivity_results = ex_output_model_sensitivity
  )
  expect_s3_class(dat, "data.frame")
  expect_equal(dim(dat), c(16, 6))
  expect_true(all(dat$pressure %in% ex_output_model_exposure$pressure))
  expect_true(all(dat$indicator %in% ex_output_model_sensitivity$indicator))

  expect_type(dat$pressure, "character")
  expect_type(dat$indicator, "character")
  expect_type(dat$type, "character")
  expect_type(dat$vulnerability, "double")
  expect_type(dat$uncertainty, "double")
})


test_that("warnings display", {
  expect_warning(vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = ex_output_calc_sensitivity,
    method_uncertainty = "blub"
  ))
  expect_warning(vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = ex_output_calc_sensitivity,
    method_vulnerability = "blub")
  )
  expect_warning(vulnerability(
    exposure_results = ex_output_calc_exposure[-1, ],
    sensitivity_results = ex_output_calc_sensitivity
  ))

})


test_that("using different aggregation methods", {
  # both aggregations mean
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = ex_output_calc_sensitivity
  )
  expect_equal(round(dat$vulnerability[11:20], digits = 2),
    c(-3.56, -2.12, -2.44, 1.31, -4.5, -7, -3.69, -4.5, 3.94, -6.25))
  expect_equal(round(dat$uncertainty[11:20], digits = 2),
    c(1.33, 1.33, 2.17, 2, 1.25, 1.33, 1.33, 2.17, 2, 1.25))

  # both aggregations median
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = ex_output_calc_sensitivity,
    method_vulnerability = "median",
    method_uncertainty = "median"
  )
  expect_equal(dat$vulnerability[11:20],
    c(-4.25, -2.125, -2.75, 0, -4.5, -6.75, -4.75, -4.25, 4.75, -8))
  expect_equal(dat$uncertainty[11:20],
    c(1, 1, 2, 2, 1, 1, 1, 2, 2, 1))

  # both aggregations minimum
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = ex_output_calc_sensitivity,
    method_uncertainty = "minimum",
    method_vulnerability = "minimum"
  )
  expect_equal(dat$vulnerability[11:20],
    c(-5.75, -4.25, -4.25, 0, -9, -7.75, -5.25, -5.25, 0, -9))
  expect_equal(dat$uncertainty[11:20],
    c(1, 1, 2, 2, 1, 1, 1, 2, 2, 1))

  # both aggregations median
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = ex_output_calc_sensitivity,
    method_uncertainty = "maximum",
    method_vulnerability = "maximum"
  )
  expect_equal(dat$vulnerability[11:20],
    c(0, 0, 0, 5.25, 0, -6.75, 0, -4.25, 6.25, 0))
  expect_equal(dat$uncertainty[11:20],
    c(2, 2, 2.5, 2, 1.75, 2, 2, 2.5, 2, 1.75))

})


test_that("vulnerability special cases", {
  # vulnerability is 0 if sensitivity was 0
  sens <- ex_output_calc_sensitivity
  sens[1, 9:13] <- 0
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = sens
  )
  expect_equal(dat$vulnerability[1], 0)

  # vulnerability is NaN if sensitivity was NA
  sens[1, 9:13] <- NA
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = sens
  )
  expect_equal(dat$vulnerability[1], NaN) # must be NaN because we use the argument na.rm = TRUE when aggregating the vulnerabilty scores across traits

  # vulnerability is 0 if exposure is 0
  exp <- ex_output_calc_exposure
  exp$exposure[1] <- 0
  dat <- vulnerability(
    exposure_results = exp,
    sensitivity_results = ex_output_calc_sensitivity
  )
  expect_equal(dat$vulnerability[1], 0)

  # adjsen is sensitivity if AC is NA
  sens <- ex_output_calc_sensitivity
  sens[1, 14:18] <- NA
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = sens
  )
  expect_equal(dat$vulnerability[1], -5.75)

  # general scores: test that sensitivity is NA if input was NA
  sens <- ex_output_calc_sensitivity[ ,-c(9:12, 14:17)]
  sens[1, 9] <- NA
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = sens
  )
  expect_equal(dat$vulnerability[1], -NA)

  # general scores: adjsen is sen if AC is NA
  sens <- ex_output_calc_sensitivity[ ,-c(9:12, 14:17)]
  sens[1, 10] <- NA
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = sens
  )
  expect_equal(dat$vulnerability[1], -5.75)

})


test_that("trimming of values works", {
  sens <- ex_output_calc_sensitivity[1:2, ]
  sens[1, 9:13] <- 5
  sens[1, 14:18] <- 1
  sens[2, 9:13] <- -5
  sens[2, 14:18] <- -1
  exp <- ex_output_calc_exposure[1:2, ]
  exp$exposure <- c(6, 6)
  dat <- vulnerability(
    exposure_results = exp,
    sensitivity_results = sens
  )

  expect_equal(dat$vulnerability, c(10, -10))

})


test_that("function works with output from modelling functions",{
  dat <- vulnerability(
    exposure_results = ex_output_model_exposure,
    sensitivity_results = ex_output_model_sensitivity
  )
  expect_equal(dat$vulnerability[1:11],
    c(6, 0, 0, 0, 3, 4.25, 0, 0, -4, 0, -3.25))

})


test_that("function works if trait based and general sensitivity scores are provided at the same time", {
  sens <- ex_output_calc_sensitivity
  sens$traits_ac.ac_reproduction <- NA
  dat <- vulnerability(
    exposure_results = ex_output_calc_exposure,
    sensitivity_results = sens
  )
  expect_equal(dat$vulnerability[1:5],
    c(-4.75, 0, -2.25, -4.25, 0))

})

