% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModels.R
\name{getModels}
\alias{getModels}
\title{Get models}
\usage{
getModels(
  occs,
  rasts,
  region = NULL,
  nbg = 10000,
  seed = NULL,
  bias = FALSE,
  collin = TRUE,
  maxcor = 0.75,
  maxvif = 5,
  classes = "default",
  regmult = 1,
  nreps = 10,
  test = 0.2,
  file = NULL,
  verbosity = 2
)
}
\arguments{
\item{occs}{species occurrence coordinates (2 columns in this order: x, y or LONGitude, LATitude) in an object coercible to a data.frame (e.g. a data.frame, matrix, tibble, sf object or SpatVector of points), and in the same coordinate reference system as 'rasts'}

\item{rasts}{(multi-layer) SpatRaster with a time series of variables to use in the models. The layers should be ordered chronologically, and their names should be in the form "varname [underscore] time", e.g. "tmin_1985" or "tmin_1" (with no more underscores than this), as in the output of \code{\link[=getVariables]{getVariables()}}. Note that, if a variable has no spatial variation in a given time step or period, it is excluded (as it cannot have an effect) from that model, so in practice not all models will include the exact same set of variables. If verbosity > 1, messages will report which variables were excluded from each period.}

\item{region}{optional SpatExtent or SpatVector polygon delimiting the region of 'rasts' within which to compute the models. The default is NULL, to use the entire extent of 'rasts' with pixel values. Note that 'region' should ideally include only reasonably surveyed areas that are accessible to the species, as pixels that don't overlap presence points are taken by Maxent as available and unoccupied.}

\item{nbg}{integer value indicating the maximum number of background pixels to select randomly for use in the models. The default is 10,000, or the total number of non-NA pixels in 'rasts' if that's less.}

\item{seed}{optional integer value to pass to \code{\link[=set.seed]{set.seed()}} specifying the random seed to use for sampling the background pixels (if 'nbg' is smaller than the number of pixels in 'rasts') and for extracting the test samples (if nreps > 0).}

\item{bias}{argument to pass to \code{\link[fuzzySim:selectAbsences]{fuzzySim::selectAbsences()}} specifying if/how the selection of unoccupied background points should be biased to incorporate survey effort. Can be TRUE to make selection more likely towards the vicinity of occurrence points (which may indicate that those areas have been surveyed); or a SpatRaster of weights (bias layer), with the same coordinate reference system as 'occs' and 'rasts', with higher values where selection should be proportionally more likely, and zero or NA where points should not be placed. Default FALSE.}

\item{collin}{logical value indicating whether multicollinearity among the variables should be reduced prior to computing each model. The default is TRUE, in which case the \code{\link[collinear:collinear]{collinear::collinear()}} function is used. Note that, if the collinearity structure varies among periods, the set of included variables may also vary. If verbosity > 1, messages will report which variables were excluded from each period.}

\item{maxcor}{numeric value to pass to \code{\link[collinear:collinear]{collinear::collinear()}} (if collin = TRUE) indicating the maximum correlation allowed between any pair of predictor variables. The default is 0.75.}

\item{maxvif}{numeric value to pass to \code{\link[collinear:collinear]{collinear::collinear()}} (if collin = TRUE) indicating the maximum VIF allowed for selected predictor variables. The default is 5.}

\item{classes}{character value to pass to \code{\link[maxnet:maxnet]{maxnet::maxnet.formula()}} indicating the continuous feature classes desired. Can be "default" or any subset of "lqpht" (linear, quadratic, product, hinge, threshold) -- for example, "lqh" for just linear, quadratic and hinge features. See References for guidance.}

\item{regmult}{numeric value to pass to \code{\link[maxnet:maxnet]{maxnet::maxnet()}} indicating the constant to adjust regularization. The default is 1. See References for guidance.}

\item{nreps}{integer value indicating the number of train-test datasets for testing the models. The default is 10. With nreps = 0, there is no division of the dataset into train and test samples, so models are trained on the entire dataset for each period. If nreps > 0, presences are randomly assigned to the train and test sample in each replicate (in the proportion defined by the 'test' argument), while the background remains the same.}

\item{test}{(if nreps > 0) numeric value indicating the proportion of presences to set aside for testing each model. The default is 0.2, i.e. 20\%.}

\item{file}{optional file name (including path, not including extension) if you want the output list of model objects to be saved on disk. If 'file' already exists in the working directory (meaning that models were already computed), models are imported from there.}

\item{verbosity}{integer value indicating the amount of messages to display. The default is 2, for the maximum number of messages available.}
}
\value{
A list of three elements:

$models: a list of lists of model objects of class \link[maxnet:maxnet]{maxnet::maxnet}. Each element of the list corresponds to a period (e.g. period), and each sub-element a replicate.

$data: a data frame with the presences, remaining background points and their environmental values used in the model(s).
}
\description{
This function computes \code{\link[maxnet:maxnet]{maxnet::maxnet()}} ecological niche models for a set of time steps or periods (e.g. years), given a set of presence point coordinates and periodly environmental layers.
}
\examples{
# Several data prep steps required.
# See https://github.com/AMBarbosa/ecotrends for a full worked example.
}
\references{
Elith J., Phillips S.J., Hastie T., Dudik M., Chee Y.E., Yates, C.J. (2011) A Statistical Explanation of MaxEnt for Ecologists. Diversity and Distributions 17:43-57. http://dx.doi.org/10.1111/j.1472-4642.2010.00725.x

Merow C., Smith M.J., Silander J.A. (2013) A practical guide to MaxEnt for modeling species' distributions: what it does, and why inputs and settings matter. Ecography 36:1058-1069. https://doi.org/10.1111/j.1600-0587.2013.07872.x
}
\seealso{
\code{\link[maxnet:maxnet]{maxnet::maxnet()}}
}
\author{
A. Marcia Barbosa
}
