% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_precedence.R
\name{filter_precedence}
\alias{filter_precedence}
\alias{filter_precedence.eventlog}
\alias{filter_precedence.grouped_eventlog}
\alias{ifilter_precedence}
\title{Filter: precedence relations}
\usage{
filter_precedence(eventlog, antecedents, consequents, precedence_type,
  filter_method, reverse)

\method{filter_precedence}{eventlog}(eventlog, antecedents, consequents,
  precedence_type = c("directly_follows", "eventually_follows"),
  filter_method = c("all", "one_of", "none"), reverse = FALSE)

\method{filter_precedence}{grouped_eventlog}(eventlog, antecedents, consequents,
  precedence_type = c("directly_follows", "eventually_follows"),
  filter_method = c("all", "one_of", "none"), reverse = FALSE)

ifilter_precedence(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{antecedents, consequents}{The set of antecendent and consequent activities. Both are character vectors containing at leaste one activity identifier.
All pairs of antecedents and consequents are turned into seperate precedence rules.}

\item{precedence_type}{When \code{directly_follows}, the consequent activity should happen immediately after the antecedent activities.
When \code{eventually_follows}, other events are allowed to happen in between.}

\item{filter_method}{When \code{each}, only cases where all the relations are valid are preserved. When \code{one_of}, all the cases where
at least one of the conditions hold are preserved.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters cases based on the precedence relations between two sets of activities.
}
\details{
In order to extract a subset of an event log which conforms with a set of precedence rules, one can use the filter_precedence method. There are two types of
precendence relations which can be tested: activities that should directly follow each other,
or activities that should eventually follow each other. The type can be set with the precedence type argument.
Further, the filter requires a vector of one or more antecedents (containing activity labels), and one or more consequents. Finally, also a filter method argument
can be set. This argument is relevant when there is more than one antecedent or consequent.
In such a case, you can specify that all possible precedence combinations must be present (all), at least one of them (one of), or none (none).
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
