% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_activity_instance.R
\name{filter_activity_instance}
\alias{filter_activity_instance}
\alias{filter_activity_instance.eventlog}
\alias{filter_activity_instance.grouped_eventlog}
\title{Filter Activity Instance}
\usage{
filter_activity_instance(
  log,
  activity_instances,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_activity_instance}{eventlog}(
  log,
  activity_instances,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_activity_instance}{grouped_eventlog}(
  log,
  activity_instances,
  reverse = FALSE,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{eventlog}}: Object of class \code{\link[bupaR]{eventlog}} or derivatives (\code{\link[bupaR]{grouped_eventlog}}).}

\item{activity_instances}{A vector of activity instance identifiers.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Filters the log based on activity instance identifier. This method has an \code{activity_instances} argument,
to which a vector of identifiers can be given. The selection can be negated with the \code{reverse} argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_activity_instance(eventlog)}: Filters activities for an \code{\link[bupaR]{eventlog}}.

\item \code{filter_activity_instance(grouped_eventlog)}: Filters activities for a \code{\link[bupaR]{grouped_eventlog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
Other filters: 
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_activity}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_case}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_precedence}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_resource}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trace}()},
\code{\link{filter_trim_lifecycle}()},
\code{\link{filter_trim}()}
}
\concept{filters}
\concept{filters_event}
