% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_endpoints.R
\name{filter_endpoints}
\alias{filter_endpoints}
\alias{filter_endpoints.log}
\alias{filter_endpoints.grouped_log}
\title{Filter Start and End Activities}
\usage{
filter_endpoints(
  log,
  start_activities = NULL,
  end_activities = NULL,
  percentage = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_endpoints}{log}(
  log,
  start_activities = NULL,
  end_activities = NULL,
  percentage = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_endpoints}{grouped_log}(
  log,
  start_activities = NULL,
  end_activities = NULL,
  percentage = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{start_activities, end_activities}{\code{\link{character}} vector (default \code{\link{NULL}}): A vector of activity identifiers, or \code{\link{NULL}}.}

\item{percentage}{\code{\link{numeric}} (default \code{\link{NULL}}): A percentage p to be used as percentile cut off. When this is used, the most common endpoint-pairs will be selected
until at least the p\% of the cases are selected.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Filters the log based on a provided set of start and end activities

The \code{filter_endpoints} method filters cases based on the first and last activity label. It can be used in two ways: by specifying vectors with allowed start
activities and/or allowed end activities, or by specifying a percentile. In the latter case, the percentile value will be used as a cut off.
For example, when set to \code{0.9}, it will select the most common endpoint pairs which together cover at least 90\% of the cases, and filter the log accordingly.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_endpoints(log)}: Filters cases for a \code{\link[bupaR]{log}}.

\item \code{filter_endpoints(grouped_log)}: Filters cases for a \code{\link[bupaR]{grouped_log}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
Other filters: 
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_activity}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_case}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_flow_time}()},
\code{\link{filter_idle_time}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_precedence}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_resource}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trace}()},
\code{\link{filter_trim_lifecycle}()},
\code{\link{filter_trim}()}
}
\concept{filters}
\concept{filters_case}
