% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFilingHeader.R
\name{getFilingHeader}
\alias{getFilingHeader}
\title{Scrape EDGAR filing header information}
\usage{
getFilingHeader(cik.no, form.type, filing.year)
}
\arguments{
\item{cik.no}{vector of CIK number of firms in integer format. Suppress leading 
zeroes from CIKs. Keep cik.no = 'ALL' if needs to download for all CIKs.}

\item{form.type}{character vector containing form type to be downloaded. 
form.type = 'ALL' if need to download all forms.}

\item{filing.year}{vector of four digit numeric year}
}
\value{
Function returns dataframe containing CIK number, company name, 
date of filing, accession number, confirmed period of report, fiscal year end,
Standard Industrial Classification (SIC) code, Internal Revenue Code (IRS) 
code, state of incorporation, business address, and mailing address. If a 
filing contains multiple filers then output will contain header information on 
all the filers in multiple rows.
}
\description{
\code{getFilingHeader} Extract EDGAR filing header information
}
\details{
getFilingHeader function takes CIK(s), form type(s), and year(s) as input parameters.  
The function first imports available downloaded filings in local woking directory 
'Edgar filings' created by \link[edgar]{getFilings} function; otherwise, 
it downloads the filings which is not already been downloaded.
It then reads the filings, and parse all the important header information.
The function returns a dataframe with filing information, and header information.
}
\examples{
\dontrun{

header.df <- getFilingHeader(cik.no = c('1000180', '38079'), 
                         form.type = '10-K', filing.year = 2006) 
              
header.df <- getFilingHeader(cik.no = '38079', c('10-K', '10-Q'), 
                         filing.year = c(2005, 2006))
}
}
