% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edibble.R
\name{design-helpers}
\alias{design-helpers}
\alias{is_edibble_design}
\alias{is_named_design}
\alias{is_edibble_table}
\alias{is_edibble_graph}
\alias{is_edibble}
\alias{is_edibble_levels}
\alias{is_nest_levels}
\alias{is_cross_levels}
\alias{edbl_design}
\alias{edbl_table}
\title{Test and get edibble objects}
\usage{
is_edibble_design(x)

is_named_design(x)

is_edibble_table(x)

is_edibble_graph(x)

is_edibble(x)

is_edibble_levels(x)

is_nest_levels(x)

is_cross_levels(x)

edbl_design(x)

edbl_table(x)
}
\arguments{
\item{x}{An object.}
}
\value{
A logical value.
}
\description{
The \code{is} functions tests if an object (or an object in its attribute)
inherits particular class and returns \code{TRUE} if it does, otherwise \code{FALSE}.
\itemize{
\item \code{is_edibble_design} checks if it inherits \code{edbl_design}.
\item \code{is_edibble_graph} checks if it inherits \code{edbl_graph}.
\item \code{is_edibble_table} checks if it inherits \code{edbl_table}
\item \code{is_edibble} checks if the object inherits \code{edbl}.
The search is quite simple, it checks if
the object is \code{edbl_design}, failing that it looks to see if the
attribute "design" of the object is \code{edbl_design}.
\item \code{is_named_design} check if it inherits \code{NamedDesign}.
}

The \code{get} functions extracts the requested edibble component (table, graph,
or design) from the object if possible.
\itemize{
\item \code{edbl_design} tries to get \code{edbl_design}.
\item \code{edbl_table} tries to get \code{edbl_table} with no design attribute.
\item \code{edbl_graph} tries to get \code{edbl_graph}.
}
}
\examples{
is_edibble_design(takeout())
}
