% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkWM.R
\name{checkWM}
\alias{checkWM}
\title{Check whether cues and outcomes exist in a weight matrix and optionally add.}
\usage{
checkWM(cues, outcomes, wm)
}
\arguments{
\item{cues}{A vector with cues.}

\item{outcomes}{A vector with outcomes.}

\item{wm}{A matrix with connection weights between cues and outcomes.}
}
\value{
A weightmatrix (matrix)
}
\description{
Check whether cues and outcomes exist in a weight matrix and optionally add.
}
\examples{
data(dat)
# create training data:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- 1
train <- createTrainingData(dat)
# train network:
wm <- RWlearning(train)
# inspect weight matrix:
wm[[1]]
# retrieve cues and outcomes from data:
c <- getCues(wm)
o <- getOutcomes(wm)
# add missing cues to initial weight matrix:
checkWM(c, o, wm=wm[[1]])

}
\author{
Jacolien van Rij
}
