% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNetwork.R
\name{plotNetwork}
\alias{plotNetwork}
\title{Return strong weights.}
\usage{
plotNetwork(
  wm,
  select.outcomes = NULL,
  select.cues = NULL,
  color = NULL,
  zlim = NULL,
  add.color.legend = TRUE,
  ...
)
}
\arguments{
\item{wm}{a weightmatrix (matrix, not list) with connection 
weights between cues (rows) and outcomes (columns).}

\item{select.outcomes}{Optional selection of outcomes to limit the number 
of connection weights that are returned. The value of NULL (default) will 
return all connection weights. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use \code{\link{getOutcomes}} for returning all cues from the data, 
and \code{\link{getValues}} for returning all cues in the data.}

\item{select.cues}{Optional selection of cues to limit the number of 
connection weights that are returned. The value of NULL (default) will 
return all connection weights. Note that specified values that are not in 
the weightmatrices will return the initial value without error or warning. 
Please use \code{\link{getCues}} for returning all cues from the data, and 
\code{\link{getValues}} for returning all cues in the data.}

\item{color}{The color scheme to use for plots, a list of colors such as 
that generated by \code{\link[grDevices]{rainbow}}, 
\code{\link[grDevices]{heat.colors}}, 
\code{\link[grDevices]{colors}}, 
\code{\link[grDevices]{topo.colors}}, 
\code{\link[grDevices]{terrain.colors}} or similar functions. 
Alternatively a vector with some colors can be provided for a 
custom color palette.}

\item{zlim}{z-limits for the plot.}

\item{add.color.legend}{Logical: whether or not to add a color legend 
(see also \code{\link[plotfunctions]{gradientLegend}}).}

\item{...}{Optional graphical arguments, as specified in 
\code{\link[graphics]{par}}. These parameters are forwarded to the functions 
\code{\link[plotfunctions]{emptyPlot}}, \code{\link[graphics]{lines}}, and 
\code{\link[graphics]{text}}.}
}
\value{
No return value
}
\description{
Return strong weights.
}
\author{
Jacolien van Rij
}
