% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{mapping_fn}
\alias{mapping_fn}
\title{Compute areas of intersection between each election boundary and those in
the Census of interest.}
\usage{
mapping_fn(aec_sF, abs_sF, area_thres = 0.995)
}
\arguments{
\item{aec_sF}{shapefile with boundaries at election time}

\item{abs_sF}{shapefile with boundaries at census time}

\item{area_thres}{threshold for which mapping is sufficient (default is 99.5\%)}
}
\value{
data frame detailing how much Census divisions intersect with each 
electoral division at the time of the election.
}
\description{
At the time of an election, compute how much each electoral division
intersects with the divisions in place at the time of the Census.
This is to be used in interpolating Census information for electoral
divisions in a year that a Census did not occur.
}
\examples{
\dontrun{
# Each 2013 electorate boundary's composition in terms of the 
# boundaries in place for the 2016 Census
aec_sF_2013 <- loadShapeFile(path_to_aec_shapefile)
abs_sF_2016 <- loadShapeFile(path_to_abs_shapefile)

mapping_df <- mapping_fn(aec_sF = aec_sF_2013, abs_sF = abs_sF_2016, area_thres = 0.995)
}
}
