% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nat_map16}
\alias{nat_map16}
\title{Map of Australian Electorates from 2016}
\format{A data frame with the following variables:
\itemize{
    \item id: Numeric identifier for the polygon
    \item long: longitude coordinate of point in polygon
    \item lat: latitude coordinate of point in polygon
    \item order: order for polygon points
    \item hole: whether polygon has a hole
    \item piece: piece for polygon
    \item group: group for polygon
    \item elect_div: Electoral division name
    \item state: Abbreviation for state name
}}
\usage{
nat_map16
}
\description{
A dataset containing the map of the all 150 Australian electorates using the 2016 boundaries of the 
The data were obtained from the Australian Electoral Commission, and downloaded 
from \url{http://www.aec.gov.au/Electorates/gis/gis_datadownload.htm}. Must be loaded using the
`nat_map_download` function.
}
\examples{

library(eechidna)
nat_map16 <- nat_map_download(2016)
# choropleth map with Australian Census data
nat_map16$region <- nat_map16$elect_div
data(abs2016)
abs2016$region <- abs2016$DivisionNm
library(ggplot2)
library(ggthemes)
both <- intersect(unique(abs2016$region), unique(nat_map16$region))
ggplot(aes(map_id=region), data=subset(abs2016, region \%in\% both)) +
  geom_map(aes(fill=MedianPersonalIncome), map=subset(nat_map16, region \%in\% both)) +
  expand_limits(x=nat_map16$long, y=nat_map16$lat) + 
  theme_map()

}
\keyword{datasets}
