% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{EftsDataSet-class}
\alias{EftsDataSet-class}
\alias{EftsDataSet}
\title{Reference class convenient for access to a Ensemble Forecast Time Series in netCDF file.}
\description{
Reference class convenient for access to a Ensemble Forecast Time Series in netCDF file.
}
\section{Fields}{

\describe{
\item{\code{time_dim}}{a cached POSIXct vector, the values for the time dimension of the data set.}

\item{\code{time_zone}}{the time zone for the time dimensions of this data set.}

\item{\code{identifiers_dimensions}}{a cache, list of values of the primary data identifiers; e.g. station_name or station_id}

\item{\code{stations_varname}}{name of the variable that stores the names of the stations for this data set.}
}}

\section{Methods}{

\describe{
\item{\code{get_all_series(variable_name = "rain_obs",
  dimension_id = get_stations_varname())}}{Return a multivariate time series, where each column is the series for one of the identifiers (e.g. rainfall station identifiers)}

\item{\code{get_dim_names()}}{Gets the name of all dimensions in the data set}

\item{\code{get_ensemble_for_stations(variable_name = "rain_sim", identifier,
  dimension_id = "ens_member", start_time = NA, lead_time_count = NA)}}{Return a time series, representing a single ensemble member forecast for all stations over the lead time}

\item{\code{get_ensemble_forecasts(variable_name = "rain_sim", identifier,
  dimension_id = get_stations_varname(), start_time = NA,
  lead_time_count = NA)}}{Return a time series, ensemble of forecasts over the lead time}

\item{\code{get_ensemble_forecasts_for_station(variable_name = "rain_sim", identifier,
  dimension_id = get_stations_varname())}}{Return an array, representing all ensemble member forecasts for a single stations over all lead times}

\item{\code{get_ensemble_series(variable_name = "rain_ens", identifier,
  dimension_id = get_stations_varname())}}{Return an ensemble of point time series for a station identifier}

\item{\code{get_ensemble_size()}}{Length of the ensemble size dimension}

\item{\code{get_lead_time_count()}}{Length of the lead time dimension}

\item{\code{get_single_series(variable_name = "rain_obs", identifier,
  dimension_id = get_stations_varname())}}{Return a single point time series for a station identifier. Falls back on get_all_series if the argument "identifier" is missing}

\item{\code{get_station_count()}}{Length of the lead time dimension}

\item{\code{get_stations_varname()}}{Gets the name of the variable that has the station identifiers}

\item{\code{get_time_dim()}}{Gets the time dimension variable as a vector of date-time stamps}

\item{\code{get_time_unit()}}{Gets the time units of a read time series, i.e. "hours since 2015-10-04 00:00:00 +1030". Returns the string "hours"}

\item{\code{get_time_zone()}}{Gets the time zone to use for the read time series}

\item{\code{get_utc_offset(as_string = TRUE)}}{Gets the time zone to use for the read time series, i.e. "hours since 2015-10-04 00:00:00 +1030". Returns the string "+1030" or "-0845" if as_string is TRUE, or a lubridate Duration object if FALSE}

\item{\code{get_values(variable_name)}}{Gets (and cache in memory) all the values in a variable. Should be used only for dimension variables}

\item{\code{get_variable_dim_names(variable_name)}}{Gets the names of the dimensions that define the geometry of a given variable}

\item{\code{get_variable_names()}}{Gets the name of all variables in the data set}

\item{\code{index_for_identifier(identifier, dimension_idifier = get_stations_varname())}}{Gets the index at which an identifier is found in a dimension variable}

\item{\code{index_for_time(dateTime)}}{Gets the index at which a date-time is found in the main time axis of this data set}

\item{\code{initialize(nc = NULL)}}{Create an object wrapping an ncdf4 object}

\item{\code{put_ensemble_forecasts(x, variable_name = "rain_sim", identifier,
  dimension_id = get_stations_varname(), start_time = NA)}}{Puts one or more ensemble forecast into a netCDF file}

\item{\code{put_ensemble_forecasts_for_station(x, variable_name = "rain_sim", identifier,
  dimension_id = "ens_member", start_time = NA)}}{Puts a single ensemble member forecasts for all stations into a netCDF file}

\item{\code{put_ensemble_series(x, variable_name = "rain_ens", identifier,
  dimension_id = get_stations_varname())}}{Puts an ensemble of time series, e.g. replicate rainfall series}

\item{\code{put_single_series(x, variable_name = "rain_obs", identifier,
  dimension_id = get_stations_varname(), start_time = NA)}}{Puts a time series, or part thereof}

\item{\code{put_values(x, variable_name)}}{Puts all the values in a variable. Should be used only for dimension variables}

\item{\code{set_time_zone(tzone_id)}}{Sets the time zone to use for the read time series}

\item{\code{summary()}}{Print a summary of this EFTS netCDF file}
}}

\seealso{
See
   \code{\link{create_efts}} and \code{\link{open_efts}} for examples on how to read or write EFTS netCDF files using this dataset.
}
