% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{create_global_attributes}
\alias{create_global_attributes}
\title{Define a set of global attributes for netCDF files.}
\usage{
create_global_attributes(title, institution, source, catchment, comment,
  strict = FALSE)
}
\arguments{
\item{title}{text, a succinct description of what is in the dataset}

\item{institution}{text, Where the original data was produced}

\item{source}{text, published or web-based references that describe the data or methods used to produce it}

\item{catchment}{text, the catchment for which the data is created. White spaces are replaced with underscores}

\item{comment}{text, miscellaneous information}

\item{strict}{logical, if true perform extra checks on the input information}
}
\description{
The conventions require a set of global attributes to be present, 
see \url{https://github.com/jmp75/efts/blob/master/docs/netcdf_for_water_forecasting.md#global-attributes}.
This function is recommended to define these attributes.
}
