% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categories.R
\name{eia_updates}
\alias{eia_updates}
\title{EIA data updates}
\usage{
eia_updates(
  id = NULL,
  deep = FALSE,
  n = 50,
  start = 1,
  tidy = TRUE,
  key = eia_get_key()
)
}
\arguments{
\item{id}{integer, category ID, may be a vector. If \code{NULL}, the API root category.}

\item{deep}{logical, if \code{TRUE}, return information on all child series. If \code{FALSE} (default), return only for the category \code{id}.}

\item{n}{integer, maximum number of rows of series to return. Defaults to 50; maximum permitted by the API is 10,000.}

\item{start}{integer, row to start from, defaults to 1.}

\item{tidy}{logical, return a tidier result. See details.}

\item{key}{API key: character if set explicitly; not needed if key is set globally. See \code{\link{eia_set_key}}.}
}
\value{
a tibble data frame (or a list, or character, depending on \code{tidy} value)
}
\description{
Obtain information on EIA data series updates for a given category to avoid having to make requests for data that have not been updated since your last request.
}
\details{
This function returns paginated results of the most recent update dates for data series.
\code{n} and \code{start} help with stepping through chunks.

If you need to know the most recent update stamps for a large set of series, you should use this function,
which makes an API call specifically to the EIA \code{updates} endpoint for specific EIA categories by category ID.
If you are only interested in update times for a specific set of series IDs,
you can use \code{\link{eia_series_updates}}.
Note that while this function accepts a vector of IDs for \code{id}, it must make one API call per ID.

By default, additional processing is done to return a tibble data frame.
Set \code{tidy = FALSE} to return only the initial list result of \code{jsonlite::fromJSON}.
Set \code{tidy = NA} to return the original JSON as a character string.
}
\examples{
\dontrun{
# use eia_set_key() to store stored API key
eia_updates(742, n = 5)
}
}
\seealso{
\code{\link{eia_series_updates}}
}
