% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_munich.R
\name{to_munich}
\alias{to_munich}
\title{Export emissions to Model of Urban Network of Intersecting Canyons and Highways (MUNICH)}
\usage{
to_munich(sdf, idbrin, typo, width, height, crs = 4326)
}
\arguments{
\item{sdf}{Street Emissions object class 'sf' LINESTRING or "SpatialLinesdataFrame".
The columns are the emissions.}

\item{idbrin}{Integer; id.}

\item{typo}{Integer; id2.}

\item{width}{Integer; width.}

\item{height}{Integer; heigth.}

\item{crs}{Numeric; Coordenade Reference System with default value of 4326.}
}
\value{
A list with a data frame with columns "i", "idbrin", "typo", "xa",
"ya", "xb", "yb" and the pollutants; and another data.frame with "i",
"length" (m), "width" (with value 0) and "height" (with value 0). Width and
height must be obtained by the user.
}
\description{
\code{\link{to_munich}} Export spatial emissions objects
according the format required by MUNICH. This function was designed to
read street emissions from VEIN by it can be used to read any other.
}
\note{
The user must ensure that the spatial object has one line feature
per vertex and lines with more than one vertex must be previously splitted.
}
\examples{
{
# Do not run
data(emisco)
dfco <- emisco[1:1000,"V8"]
etm <- to_munich(sdf = dfco)
names(etm)
class(etm)
head(etm$Emissions)
head(etm$Street)
write.table(x = etm$Emissions, file = paste0(tempfile(), "_Emissions.txt"),
row.names = FALSE, sep = " ", quote = FALSE)
write.table(x = etm$Street, file = paste0(tempfile(), "_Street.txt"),
row.names = FALSE, sep = " ", quote = FALSE)
}
}
\references{
Kim, Y., Wu, Y., Seigneur, C., and Roustan, Y.:
Multi-scale modeling of urban air pollution: development and application of
a Street-in-Grid model (v1.0) by coupling MUNICH (v1.0) and Polair3D
(v1.8.1), Geosci. Model Dev., 11, 611-629,
https://doi.org/10.5194/gmd-11-611-2018, 2018.
}
