\name{audit.totals.to.OS}
\alias{audit.totals.to.OS}

\title{ Converting total vote counts to Over Statements }
\description{
  This utility function takes a collection of total votes from an audit
  and subtracts the originally reported totals from them to give
  overstatement errors (i.e., how many votes more than actual a
  candidate had).  I.e., the overstatement error is REPORTED - ACTUAL.
}
\usage{
audit.totals.to.OS(Z, audit)
}

\arguments{
  \item{Z}{ Elec.data object holding the originally reported results }
  \item{audit}{ A data.frame with one column per candidate that holds
  the totals from the audit.  Each row corresponds to a precinct.
  Object needs a PID column with precinct ids that match the ones in Z.}
}
\details{
  Make sure the audit's PID column is a character vector and not a
  factor.  If needed, convert via \code{audit\$PID = as.character(audit\$PID)}.
}
\value{
  A new data.frame with overstatement errors.
}
\examples{

## Generate a fake race, a fake audit, and then compute overstatements
Z = make.sample(0.08, 150, per.winner=0.4, R=2.01)
Z
Zb = make.ok.truth(Z, num.off=150, amount.off=5)
Zb
aud = Zb$V[ sample(1:Zb$N, 10), ]
aud
audit.totals.to.OS(Z, aud )
}

\seealso{
    See \link{AuditErrors} for different ways of summarizing audit errors.
}
\author{ Luke W. Miratrix }
