% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_fed.R
\name{candidate_fed}
\alias{candidate_fed}
\title{Download data on the candidates' backgrounds in federal elections}
\usage{
candidate_fed(year, ascii = FALSE, encoding = "windows-1252")
}
\arguments{
\item{year}{Election year (\code{integer}). For this function, only the years 1998, 2002, 2006, 2010, and 2014
are available.}

\item{ascii}{(\code{logical}). Should the text be transformed from Latin-1 to ASCII format?}

\item{encoding}{Data original encoding (defaults to 'windows-1252'). This can be changed to avoid errors
when \code{ascii = TRUE}.}
}
\value{
\code{candidate_fed()} returns a \code{data.frame} with the following variables:

\itemize{
  \item DATA_GERACAO: Generation date of the file (when the data was collected).
  \item HORA_GERACAO: Generation time of the file (when the data was collected), Brasilia Time.
  \item ANO_ELEICAO: Election year.
  \item NUM_TURNO: Round number.
  \item DESCRICAO_ELEICAO: Description of the election.
  \item SIGLA_UF: Units of the Federation's acronym in which occurred the election.
  \item SIGLA_UE: Units of the Federation's acronym (In case of major election is the FU's
  acronym in which the candidate runs for (text) and in case of municipal election is the
  municipal's Supreme Electoral Court code (number)). Assume the special values BR, ZZ and
  VT to designate, respectively, Brazil, Overseas and Absentee Ballot.
  \item DESCRICAO_UE: Description of the Electoral Unit.
  \item CODIGO_CARGO: Code of the position that the candidate runs for.
  \item DESCRICAO_CARGO: Description of the position that the candidate runs for.
  \item NOME_CANDIDATO: Candidate's complete name.
  \item SEQUENCIAL_CANDIDATO: Candidate's sequence number generated internally by the electoral
  systems. It is not the candidate's campaign number.
  \item NUMERO_CANDIDATO: Candidate's number in the ballot box.
  \item CPF_CANDIDATO: Candidate's CPF.
  \item NOME_URNA_CANDIDATO: Candidate's ballot box name.
  \item COD_SITUACAO_CANDIDATURA: Code of the candidature situation.
  \item DES_SITUACAO_CANDIDATURA: Description of the candidature situation.
  \item NUMERO_PARTIDO: Party number.
  \item SIGLA_PARTIDO: Party acronym.
  \item NOME_PARTIDO: Party name.
  \item CODIGO_LEGENDA: Sequential code of the party shortname generated by the Electoral Justice.
  \item SIGLA_LEGENDA: Party's shortname acronym.
  \item COMPOSICAO_LEGENDA: Party's shortname composition.
  \item NOME_COLIGACAO: Coalition shortname.
  \item CODIGO_OCUPACAO: Candidate's occupation code.
  \item DESCRICAO_OCUPACAO: Candidate's occupation description.
  \item DATA_NASCIMENTO: Candidate's date of birth.
  \item NUM_TITULO_ELEITORAL_CANDIDATO: Candidate's ballot number.
  \item IDADE_DATA_ELEICAO: Candidate's age on the day of election.
  \item CODIGO_SEXO: Candidate's sex code.
  \item DESCRICAO_SEXO: Candidate's sex description.
  \item COD_GRAU_INSTRUCAO: Candidate's level of education code. Generated internally by the electoral systems.
  \item DESCRICAO_GRAU_INSTRUCAO: Candidate's level of education description.
  \item CODIGO_ESTADO_CIVIL: Candidate's marital status code.
  \item DESCRICAO_ESTADO_CIVIL: Candidate's marital status description.
  \item CODIGO_NACIONALIDADE: Candidate's nationality code.
  \item DESCRICAO_NACIONALIDADE: Candidate's nationality description.
  \item SIGLA_UF_NASCIMENTO: Candidate's Units of the Federation birth's acronym.
  \item COD_MUNICIPIO_NASCIMENTO: Candidate's birth city's Supreme Electoral Court code.
  \item COD_MUNICIPIO_NASCIMENTO: Candidate's birth city.
  \item DESPESA_MAX_CAMPANHA: Maximum expenditure campaign declared by the party to that position. Values in Reais.
  \item COD_SIT_TOT_TURNO: Candidate's totalization status code in that election round.
  \item DESC_SIT_TOT_TURNO: Candidate's totalization status description in that round.
  \item CODIGO_COR_RACA: Candidate's color/race code (self-declaration, only for 2014 election).
  \item DESCRICAO_COR_RACA: Candidate's color/race description (self-declaration, only for 2014 election).
  \item EMAIL_CANDIDATO: Candidate's e-mail adress (only for 2014 election).
}
}
\description{
\code{candidate_fed()} downloads and aggregates data on the candidates' background who ran in
federal elections in Brazil. The function returns a \code{data.frame} where each observation
corresponds to a candidate.
}
\note{
For the elections prior to 2002, some information can be incomplete. For the 2014 elections, three more variables are available.
}
\examples{
\dontrun{
df <- candidate_fed(2002)
}
}

