% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.elo.glm.R
\name{predict.elo.glm}
\alias{predict.elo.glm}
\alias{predict.elo.running}
\title{Make Predictions on an \code{elo.glm} Object}
\usage{
\method{predict}{elo.glm}(object, newdata, type = "response", ...)

\method{predict}{elo.running}(object, newdata, running = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{"\link{elo.glm}"}.}

\item{newdata}{A new dataset containing the same variables as the call
that made \code{object}. If missing, the predicted win probabilities from
\code{object} will be returned.}

\item{type}{See \code{\link[stats]{predict.glm}}}

\item{...}{Other arguments.}

\item{running}{logical, denoting whether to use the running predicted values. Only makes
sense if \code{newdata} is missing.}
}
\value{
A vector of win probabilities.
}
\description{
Make Predictions on an \code{elo.glm} Object
}
\details{
Note that the \code{"elo.glm.running"} objects will use a model fit on all the data to predict.
}
\examples{
data(tournament)
t1 <- head(tournament, -3)
t2 <- tail(tournament, 3)
results <- elo.glm(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = t1,
  subset = points.Home != points.Visitor)
predict(results)
predict(results, newdata = t2)
}
