% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.elo}
\alias{predict.elo}
\alias{predict.elo.run}
\alias{predict.elo.run.regressed}
\alias{predict.elo.run.multiteam}
\alias{predict.elo.glm}
\alias{predict.elo.running}
\alias{predict.elo.markovchain}
\alias{predict.elo.colley}
\alias{predict.elo.winpct}
\title{Make Predictions on an \code{elo} Object}
\usage{
\method{predict}{elo.run}(object, newdata, ...)

\method{predict}{elo.run.regressed}(object, newdata, regressed = FALSE, ...)

\method{predict}{elo.run.multiteam}(object, newdata, ...)

\method{predict}{elo.glm}(object, newdata, type = "response", ...)

\method{predict}{elo.running}(object, newdata, running = TRUE, ...)

\method{predict}{elo.markovchain}(object, newdata, ...)

\method{predict}{elo.colley}(object, newdata, ...)

\method{predict}{elo.winpct}(object, newdata, ...)
}
\arguments{
\item{object}{An model from which to get predictions.}

\item{newdata}{A new dataset containing the same variables as the call
that made \code{object}. If missing, the predicted win probabilities from
\code{object} will be returned.}

\item{...}{Other arguments.}

\item{regressed}{See the note on \code{\link{final.elos}}.}

\item{type}{See \code{\link[stats]{predict.glm}}}

\item{running}{logical, denoting whether to use the running predicted values. Only makes
sense if \code{newdata} is missing.}
}
\value{
A vector of win probabilities.
}
\description{
Make Predictions on an \code{elo} Object
}
\details{
Note that the \code{"elo.glm.running"} objects will use a model fit on all the data to predict.
}
\examples{
data(tournament)
t1 <- head(tournament, -3)
t2 <- tail(tournament, 3)
results <- elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
                   data = t1, k = 20)
predict(results)
predict(results, newdata = t2)

results <- elo.glm(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = t1,
  subset = points.Home != points.Visitor)
predict(results)
predict(results, newdata = t2)

results <- elo.markovchain(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = t1,
  subset = points.Home != points.Visitor, k = 0.7)
predict(results)
predict(results, newdata = t2)

results <- elo.colley(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = t1,
  subset = points.Home != points.Visitor)
predict(results)
predict(results, newdata = t2)

results <- elo.winpct(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = t1,
  subset = points.Home != points.Visitor, k = 0.7)
predict(results)
predict(results, newdata = t2)
}
