% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mime.R
\name{parameter_value_encode}
\alias{parameter_value_encode}
\title{Encode parameter values for MIME headers}
\usage{
parameter_value_encode(x)
}
\arguments{
\item{x}{\code{character(1)}. UTF-8 string to format.}
}
\value{
\code{character(1)}. String to put right after the parameter name in
a MIME header. The equal sign and possible quotation marks are included.
For example \code{"I'm not quoted.csv"} turns to
\code{"=\\"I'm not quoted.csv\\""} while \code{"\\"I'm quoted\\".csv"}
results in \code{"*=utf-8''\%22I'm\%20quoted\%22.csv"}.
}
\description{
Formats UTF-8 parameter values for the use in MIME headers. Non-ASCII
characters, control characters, and some special characters have to be
specially encoded according to the
\href{https://tools.ietf.org/html/rfc2231}{RFC2231} specification.
}
\examples{
emayili:::parameter_value_encode("I'm not quoted.csv")
emayili:::parameter_value_encode("\"I'm quoted\".csv")
}
