% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarkers.R
\name{get_synergy_biomarkers_from_dir}
\alias{get_synergy_biomarkers_from_dir}
\title{Get synergy biomarkers from dir}
\usage{
get_synergy_biomarkers_from_dir(predicted.synergies, biomarkers.dir,
  models.dir, node.names = NULL)
}
\arguments{
\item{predicted.synergies}{a character vector of the synergies (drug
combination names) that were predicted by \strong{at least one} of the models
in the dataset.}

\item{biomarkers.dir}{string. It specifies the full path name of the
directory which holds the biomarker files. The biomarker files must be
formatted as: \emph{\%drug.comb\%_biomarkers_active} or
\emph{\%drug.comb\%_biomarkers_inhibited}, where \%drug.comb\% is an element
of the \code{predicted.synergies} vector.}

\item{models.dir}{string. A directory with \emph{.gitsbe} files/models. It's
needed in order to call \code{\link{get_node_names}}.}

\item{node.names}{a character vector which has the names of the nodes. If it's
not NULL, then it will be used instead of the \code{models.dir} parameter.
The \code{node.names} should include all the nodes that are reported as
biomarkers in the biomarker files inside the \code{biomarkers.dir} directory.
Default value: NULL.}
}
\value{
a data.frame, whose columns represent the network nodes and the
rows the predicted synergies. Possible values for each \emph{synergy-node}
element are either \emph{1} (\emph{active state} biomarker), \emph{-1}
(\emph{inhibited state} biomarker) or \emph{0} (not a biomarker).
}
\description{
This function reads the synergy biomarker files inside the given directory and merges
the results into a \code{data.frame} which it returns. This functions should
be used when the synergy biomarker results are in separate files inside the
directory given (see \code{biomarkers.dir} parameter).
}
