% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{get_synergy_scores}
\alias{get_synergy_scores}
\title{Get synergy scores from file}
\usage{
get_synergy_scores(file_name, file_type = "ensemblewise")
}
\arguments{
\item{file_name}{string. The name of the file, can be a full path.}

\item{file_type}{string. The type of input file, can be either \emph{ensemblewise}
(default option) or \emph{modelwise}.}
}
\value{
a \code{tibble} containing a representation of the data in the file.
}
\description{
Use this function to read \href{https://druglogics.github.io/druglogics-doc/drabme-install.html#drabme-output}{Drabme's
output files} that have synergy scores for a list of tested drug perturbations.
}
\details{
Two types of files can be read: the \emph{model-wise} and the \emph{ensemble-wise}
synergies:
\itemize{
  \item The \emph{model-wise} synergies data is structured as a 3-column
table, first being the names of the tested drug combinations, second the
number of models that predicted that combination as synergistic and the third
the number of models that predicted the drug combination as non-synergistic.
  \item The \emph{ensemble-wise} synergies data is structured as a 2-column table,
the first being the names of drug combinations and the second the ensemble-wise
synergy scores for those perturbations.
 }

Note that no matter the file type, the first line of the file is always skipped
and the columns must be \emph{tab-separated}.
See example below for the format of such files generated by the
\href{https://druglogics.github.io/druglogics-doc/drabme.html}{Drabme} module.
}
\examples{

ensemblewise_synergies_file = system.file("extdata", "ensemblewise_synergies",
  package = "emba", mustWork = TRUE)
modelwise_synergies_file = system.file("extdata", "modelwise_synergies",
  package = "emba", mustWork = TRUE)
data_ensemble = get_synergy_scores(ensemblewise_synergies_file) # file_type = "ensemblewise"
data_modelwise = get_synergy_scores(modelwise_synergies_file, file_type = "modelwise")

}
