% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HatchingSuccess.nobs.R
\name{nobs.HatchingSuccess}
\alias{nobs.HatchingSuccess}
\title{Return number of observations of a fit}
\usage{
\method{nobs}{HatchingSuccess}(object, ...)
}
\arguments{
\item{object}{The return of a fit done with fitHS.}

\item{...}{Not used}
}
\value{
Return number of observations of a fit
}
\description{
Set of functions to study the hatching success.\cr
}
\details{
nobs.NestsResult Return number of observations of a fit
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=0.8)
         
HatchingSuccess.lnL(par=par, data=totalIncubation_Cc)

g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)

HatchingSuccess.lnL(par=g$par, data=totalIncubation_Cc)

plot(g)

nobs(g)
}
}
\seealso{
Other Hatching success: 
\code{\link{HatchingSuccess.MHmcmc_p}()},
\code{\link{HatchingSuccess.MHmcmc}()},
\code{\link{HatchingSuccess.fit}()},
\code{\link{HatchingSuccess.lnL}()},
\code{\link{HatchingSuccess.model}()},
\code{\link{logLik.HatchingSuccess}()},
\code{\link{plot.HatchingSuccess}()},
\code{\link{predict.HatchingSuccess}()}
}
\author{
Marc Girondot
}
\concept{Hatching success}
