% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.excel.emdi.R
\name{write.excel}
\alias{write.excel}
\title{Exports an emdiObject to an excel file}
\usage{
write.excel(object, file = "excel_output.xlsx", indicator = "all",
  MSE = FALSE, CV = FALSE, split = FALSE)
}
\arguments{
\item{object}{an object of type "emdi", representing point and
MSE estimates.}

\item{file}{path and filename of the spreadsheet to create. It should end on .xlsx.}

\item{indicator}{optional character vector that selects which indicators
shall be returned: (i) all calculated indicators ("all");
(ii) each indicator name: "Mean" "Quantile_10", "Quantile_25", "Median",
"Quantile_75", "Quantile_90", "Head_Count", "Poverty_Gap", "Gini", 
"Quintile_Share" or the function name/s of "custom_indicator/s"; 
(ii) groups of indicators: "Quantiles", "Poverty" or 
"Inequality". Defaults to "all". Note, additional custom indicators can be 
defined as argument for model-based approaches (\code{link{ebp}}) and do not 
appear in groups of indicators even though these might belong to one of the 
groups.}

\item{MSE}{logical. If TRUE, the MSE of the emdiObject is exported.}

\item{CV}{logical. If TRUE, the CV of the emdiObject is exported.}

\item{split}{logical. If TRUE, point estimates, MSE and CV are written to
different sheets in the excel file.}
}
\description{
Function \code{write.excel} enables the user to export point and MSE 
estimates as well as diagnostics from \code{summary.emdi} to an excel file. 
The user can choose if the results should be reported in one or several excel 
sheets. Furthermore, a selection of indicators can be specified.
}
\examples{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_pop")

# Example with two additional indicators
set.seed(100); emdi_model <- ebp( fixed = eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
pov_line = 10722.66, transformation = "box.cox", L= 2, MSE = TRUE, B = 2,
custom_indicator = list( my_max = function(y, pov_line){max(y)},
my_min = function(y, pov_line){min(y)}), na.rm = TRUE, cpus = 1)

# Export estimates for all indicators and uncertainty measures and 
# diagnostics to excel
write.excel(emdi_model, file ="excel_output_all.xlsx", indicator = "all", 
MSE = TRUE, CV = TRUE)

# Single excel sheets for point, MSE and CV estimates
write.excel(emdi_model, file ="excel_output_all_split.xlsx", indicator = "all", 
MSE = TRUE, CV = TRUE, split=TRUE)
}
\seealso{
\code{\link{emdiObject}}, \code{\link{ebp}}
}

