% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{step}
\alias{step}
\alias{step.default}
\title{Step function}
\usage{
step(object, scope, criteria, direction, trace, steps, ...)

\method{step}{default}(object, ...)
}
\arguments{
\item{object}{an object of type "emdi","model" or a \code{lm} object.}

\item{scope}{formula or a list including two formulas (\code{lower} and 
\code{upper}) specifying the models considered in the step function. 
Defaults to \code{NULL}.}

\item{criteria}{a character string describing the model selection criterion.}

\item{direction}{a character string describing the direction of stepwise 
algorithm. Directions that can be chosen are "\code{both}", "\code{backward}" 
or "\code{forward}". Defaults to "\code{both}". If no \code{scope} argument is 
provided, the default is "\code{backward}".}

\item{trace}{if \code{TRUE}, information about the single steps is 
provided during the stepwise procedure. Defaults to \code{TRUE}.}

\item{steps}{a number determining the maximum number of steps. Defaults to 1000.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
The return of \code{step} depends on the class of its argument. The
documentation of particular methods gives detailed information about the
return of that method.
}
\description{
This generic function selects a model by different criteria in a stepwise 
algorithm.
}
\details{
The default method of the generic function \code{step} 
applies the \code{step} function for \code{lm} models of the stats package. 
Please refer to the documentation of the \code{step} function of 
the stats package for details.
}
\seealso{
\code{\link[stats]{step}}
}
