% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modeling.r
\name{tune}
\alias{detune}
\alias{is_tunable}
\alias{is_tuned}
\alias{tune}
\title{Tune parameters of modeling procedures}
\usage{
tune(procedure, ..., .verbose = FALSE)

is_tuned(procedure)

is_tunable(procedure)

detune(procedure)
}
\arguments{
\item{procedure}{Modeling procedure, or list of modeling procedures, as
produced by \code{\link{modeling_procedure}}.}

\item{...}{Sent to \code{\link{evaluate}}.}

\item{.verbose}{Whether to print an activity log. Set to \code{-1} to
suppress all messages.}
}
\value{
A tuned modeling procedures or a list of such.

Logical indicating if the procedure(s) are tuned.

Logical indicating if the has tunable parameters.

A list of untuned modeling procedures.
}
\description{
These functions are rarely needed to be called manually as they are
automatically called by \code{\link{fit}} and \code{\link{evaluate}}
when needed.
}
\examples{
procedure <- modeling_procedure("randomForest", parameter=list(mtry=1:4))
tuned.procedure <- tune(procedure, x=iris[-5], y=iris$Species)
mod <- fit(tuned.procedure, x=iris[-5], y=iris$Species)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{modeling_procedure}},
  \code{\link{evaluate}}, \code{\link{fit}},
  \code{\link[=predict.model]{predict}}, \code{\link{get_importance}}
}

