% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{mode}
\alias{mode}
\title{Get the most common value}
\usage{
mode(x, na.rm = FALSE, allow_multiple = TRUE)
}
\arguments{
\item{x}{Vector.}

\item{na.rm}{Whether to ignore missing values when calculating the mode.
Note that modes may be identified even if \code{x} contains missing values
as long as they are too few to affect the result.}

\item{allow_multiple}{Controls what is returned if \code{x} contains more
than one mode. If \code{TRUE} all modes are returned, if \code{FALSE}
\code{NA} is returned.}
}
\value{
The most common values or values in \code{x} or \code{NA} if could
  not be determined.
}
\description{
Get the most common value
}
\examples{
mode(mtcars$cyl)
mode(chickwts$feed)
mode(unlist(strsplit("Hello Dolly!", "")))

# Multiple modes
mode(iris$Species)

# Missing values
x <- rep(1:4, 4)
x[2:4] <- NA
mode(x)
mode(x, na.rm=TRUE)

x <- c(rep(1:3, c(4,2,1)), NA)
mode(x, na.rm=FALSE)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

