% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{auto.noise}
\alias{auto.noise}
\title{Auto Pollution Filter Noise}
\format{
A data frame with 36 observations on the following 4 variables.
  \describe{
  \item{\code{noise}}{Noise level in decibels (but see note) - a numeric vector.}
  \item{\code{size}}{The size of the vehicle - an ordered factor with
    levels \code{S}, \code{M}, \code{L}.}
  \item{\code{type}}{Type of anti-pollution filter - a factor with levels
    \code{Std} and \code{Octel}}
  \item{\code{side}}{The side of the car where measurement was taken -- a
    factor with levels \code{L} and \code{R}.}
  }
}
\source{
The dataset was obtained from the Data and Story Library (DASL)
  at Carnegie-Mellon University. Apparently it has since been removed. The
  original dataset was altered by assigning meaningful names to the factors
  and sorting the observations in random order as if this were the run order
  of the experiment.
}
\usage{
auto.noise
}
\description{
Three-factor experiment comparing pollution-filter noise for two filters,
three sizes of cars, and two sides of the car.
}
\details{
The data are from a statement by Texaco, Inc., to the Air and Water Pollution
Subcommittee of the Senate Public Works Committee on June 26, 1973.    
Mr. John McKinley, President of Texaco, cited an automobile filter developed
by Associated Octel Company as effective in reducing pollution. However, 
questions had been raised about the effects of filters on vehicle performance, 
fuel consumption, exhaust gas back pressure, and silencing. On the last 
question, he referred to the data included here as evidence that the silencing
properties of the Octel filter were at least equal to those of standard silencers.
}
\note{
While the data source claims that \code{noise} is measured in decibels,
  the values are implausible. I believe that these measurements are actually
  in tenths of dB (centibels?). Looking at the values in the dataset, note 
  that every measurement ends in 0 or 5, and it is reasonable to believe that
  measurements are accurate to the nearest half of a decibel.
  %%% Thanks to an email communication from a speech/hearing scientist
}
\examples{
# (Based on belief that noise/10 is in decibel units)
noise.lm <- lm(noise/10 ~ size * type * side, data = auto.noise)

# Interaction plot of predictions
emmip(noise.lm, type ~ size | side)

# Confidence intervals
plot(emmeans(noise.lm, ~ size | side*type))

}
\keyword{datasets}
