% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue.R
\name{emoji_glue}
\alias{emoji_glue}
\title{Glue Interpolation for Emojis}
\usage{
emoji_glue(..., .envir = parent.frame())
}
\arguments{
\item{...}{[\code{expressions}]\cr Unnamed arguments are taken to be expressions
string(s) to format. Multiple inputs are concatenated together before formatting.
Named arguments are taken to be temporary variables available for substitution.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored. If \code{NULL} is passed it is equivalent to \code{\link[=emptyenv]{emptyenv()}}.}
}
\value{
a \code{glue::glue()} string.
}
\description{
Combine the power of \code{glue::glue} and \code{emoji()}.
}
\details{
\code{emoji_glue()} behaves in much the same way a lot of messaging apps work.
Anything inside a pair of \code{:} will be interpolated into an emoji.
You can think of \code{emoji_glue()} as being a shorthand for
\code{glue("I love {emoji('taco')}s")}.

Block ending with \code{*} will be collapsed.
}
\examples{
emoji_glue("I love :taco:s")

emoji_glue("one :heart:")
emoji_glue("many :heart*:")
}
