% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{ecf_real}
\alias{ecf_real}
\title{Real part of empirical characteristic function}
\usage{
ecf_real(t, smp)
}
\arguments{
\item{t}{mxd matrix where the function will be evaluated.}

\item{smp}{nxd matrix with sample size if size n.}
}
\value{
A vector of size m with the real part of the empirical
characteristic function.
}
\description{
Real part of empirical characteristic function of a d-dimensional
random variable. This function is evaluated at m vectors of size d.
}
\details{
This function must receive matrices or vectors. It is a wrapper
function that allows more general inputs.
}
\examples{
library(empichar)
t <- seq(-10, 10, 0.05)
X <- rnorm(150)
vals <- ecf_real(t, X)
plot(t, vals, type = "l")

}
