% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-autobuild.R
\name{autobuild_linkFromTimes}
\alias{autobuild_linkFromTimes}
\title{Autobuild links between two levels using their time information}
\usage{
autobuild_linkFromTimes(emuDBhandle, superlevelName, sublevelName,
  rewriteAllAnnots = TRUE, convertSuperlevel = FALSE,
  backupLevelAppendStr = "-autobuildBackup", newLinkDefType = NULL,
  verbose = TRUE)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{superlevelName}{name of level to link from (link definition required in emuDB)}

\item{sublevelName}{name of level to link to (link definition required in emuDB)}

\item{rewriteAllAnnots}{should changes be written to file system (_annot.json files) after completing autobuild process (intended for expert use only)}

\item{convertSuperlevel}{if set to TRUE a backup of the superlevel will be created and the actual
superlevel will be converted to a level of type ITEM}

\item{backupLevelAppendStr}{string appended to level name for backup level}

\item{newLinkDefType}{type of new linkDefinition (either \code{"ONE_TO_MANY"}, \code{"MANY_TO_MANY"} or \code{"ONE_TO_ONE"}) 
which is passed to \code{\link{add_linkDefinition}}. If NULL (the default) \code{\link{add_linkDefinition}} isn't called and a linkDefintion is expected to be present.}

\item{verbose}{show progress bars and further information}
}
\description{
Autobuild links between two time levels. This is typically done when converting from 
a database / annotation format that allows parallel time tiers / levels but does not permit annotational units 
to be linked to each other, except by matching time information (such as Praat's TextGrid format). 
The super-level has to be of the 
type SEGMENT and the sub-level either of type EVENT or of type SEGMENT. If
this is the case and a according link definition is defined for the emuDB,
this function automatically links the events or segments of the sub-level which occur
within (startSample to (startSample + sampleDur)) the segments of the super-level to those segments.
}
\details{
The type of link definition (ONE_TO_MANY, MANY_TO_MANY, ONE_TO_ONE) is relevant whether a link
is generated or not (e.g. overlapping segments are linked in a MANY_TO_MANY relationship 
but not in a ONE_TO_MANY relationship). For more information on the structural 
elements of an emuDB see \code{vignette(emuDB)}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded myTGcolDB emuDB 
# (see ?create_emuRdemoData, ?convert_TextGridCollection, 
#  and vignette(emuR_intro) for more information)

# add linkDefinition as one has to be present for
# the autobuild function to work
add_linkDefinition(emuDBhandle = myTGcolDB, 
                   type = "ONE_TO_MANY",
                   superlevelName = "Syllable",
                   sublevelName = "Phoneme")
  
# envoke autobuild function to build hierarchy for converted TextGridCollection
autobuild_linkFromTimes(emuDBhandle = myTGcolDB, 
                        superlevelName = "Syllable",
                        sublevelName = "Phoneme",
                        convertSuperlevel = TRUE)

}
}
\seealso{
add_linkDefinition
}
\keyword{autobuild}
\keyword{emuR}
