% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-convert_BPFCollection.R
\name{convert_BPFCollection}
\alias{convert_BPFCollection}
\title{Convert a Bas Partitur File Collection (audio and BAS Partitur files) to an emuDB}
\usage{
convert_BPFCollection(sourceDir, targetDir, dbName, bpfExt = "par",
  audioExt = "wav", extractLevels = NULL, refLevel = NULL,
  newLevels = NULL, newLevelClasses = NULL, segmentToEventLevels = NULL,
  unifyLevels = NULL, verbose = TRUE)
}
\arguments{
\item{sourceDir}{path to the directory containing the Bas Partitur File collection}

\item{targetDir}{directory where the new emuDB should be saved; if it does not exist, 
the function tries to create one}

\item{dbName}{name given to the new emuDB}

\item{bpfExt}{extension of BPF files (default = "par")}

\item{audioExt}{extension of audio files (default = "wav")}

\item{extractLevels}{optional vector containing the names of levels that should be extracted. 
If NULL (the default) all levels found in the BPF collection are extracted.}

\item{refLevel}{optional name of level used as reference for symbolic links. If NULL (the default), a link-less data base is created.}

\item{newLevels}{optional vector containing names of levels in the BPF collection that are not part of the standard 
BPF levels. See \url{http://www.bas.uni-muenchen.de/forschung/Bas/BasFormatseng.html#Partitur_tiersdef} for details on 
standard BPF levels.}

\item{newLevelClasses}{optional vector containing the classes of levels in the newLevels vector as integers. 
Must have the same length and order as newLevels.}

\item{segmentToEventLevels}{optional vector containing names of segment levels with overlapping segments. 
The parser treats segments on these levels as events (SEGMENT xyz becomes EVENT xyz_start and EVENT xyz_end). 
If a level contains segmental overlap but is not in this vector, the parser will throw an error. If overlap 
resolution leads to event overlap (e.g. if one segment's end coincides with the next segment's start), an error is thrown either way. If in doubt whether a level contains segmental overlap, try running the converter with segmentToEventLevels = NULL and see whether an error occurs.}

\item{unifyLevels}{optional vector containing names of levels to be unified with the reference level. This means that 
they are treated as labels of the reference level rather than independent items. At the moment, only purely symbolic 
(class 1) levels can be unified. Links between the reference level and levels in unifyLevels must be one-to-one.}

\item{verbose}{display infos, warnings and show progress bar}
}
\description{
Converts a Bas Partitur File Collection to an emuDB. Expects a collection of the following form:
One master directory <sourceDir> containing any number of file pairs (= bundles). A file pair 
consists of an audio file with the extension <audioExt> and a BPF file with the extension <bpfExt>. 
Apart from extensions, the names of corresponding audio and BPF files must be identical. Each BPF 
file is converted into an emuDB annot file. An emuDB config file matching the data base is created 
after parsing.
}
\examples{
\dontrun{

##################################
# prerequisite: a dir with equally named file pairs *.wav and *.par
# (see ?create_emuRdemoData on how to create a demo)

# convert file pairs *.wav and *.par in /tmp/BPF_collection into emuRDB 'NewEmuR' in 
# dir /tmp/DirNewEmuR; the tier 'ORT' acts as the (word) reference tier; the 
# tier 'KAN' is one-to-one bound to 'ORT' as a label
convert_BPFCollection("/tmp/BPF_collection","/tmp/DirNewEmuR",'NewEmuR',
        bpfExt='par',audioExt='wav',refLevel='ORT',unifyLevels=c('KAN'))

}

}
\seealso{
convert_TextGridCollection, convert_legacyEmuDB
}
