% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.files.R
\name{add_files}
\alias{add_files}
\title{Add files to emuDB}
\usage{
add_files(emuDBhandle, dir, fileExtension, targetSessionName = "0000")
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{dir}{directory containing files to be added}

\item{fileExtension}{file extension of files to be added}

\item{targetSessionName}{name of sessions containing 
bundles that the files will be added to}
}
\description{
Add files to existing bundles of specified session of emuDB.
Do not use this function to import new recordings (media files) and create bundles; 
see \code{?import_mediaFiles} to import new recordings.
The files that are found in \code{dir} that have the extension 
\code{fileExtension} will be copied into the according bundle
folder that have the same basename as the file. Note that the 
same bundle name may appear in different sessions, therefore you must 
specify the session in \code{targetSessionName}. For 
more information on the structural elements of an emuDB 
see \code{vignette{emuDB}}.
Note that adding files does not mean the emuDB is automatically using these, unless
you have defined the usage of these files (e.g. by ssffTrackDefinitions).
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# specify path to folder containing the following
# files we wish to add to: 
# msajc003.zcr, msajc010.zcr, msajc012.zcr, msajc015.zcr, 
# msajc022.zcr, msajc023.zcr and msajc057.zcr 
path2dir = "/path/to/dir/"

# add the files to session "0000" of the "ae" emuDB
add_files(emuDBhandle = ae,
          dir = path2dir,
          fileExtension = "zcr",
          targetSessionName = "0000")

}
}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
