% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_complementos.R
\name{padronizar_complementos}
\alias{padronizar_complementos}
\title{Padronizar complementos}
\usage{
padronizar_complementos(complementos)
}
\arguments{
\item{complementos}{Um vetor de caracteres. Os complementos a serem
padronizados.}
}
\value{
Um vetor de caracteres com os complementos padronizados.
}
\description{
Padroniza um vetor de caracteres representando complementos de logradouros.
Veja a seção \emph{Detalhes} para mais informações sobre a padronização.
}
\section{Detalhes}{

Operações realizadas durante a padronização:
\itemize{
\item remoção de espaços em branco antes e depois das strings e remoção de
espaços em excesso entre palavras;
\item conversão de caracteres para caixa alta;
\item remoção de acentos e caracteres não ASCII;
\item adição de espaços após abreviações sinalizadas por pontos;
\item expansão de abreviações frequentemente utilizadas através de diversas
\href{https://en.wikipedia.org/wiki/Regular_expression}{expressões regulares (regexes)};
\item correção de alguns pequenos erros ortográficos.
}
}

\examples{
complementos <- c("", "QD1 LT2 CS3", "APTO. 405")
padronizar_complementos(complementos)

}
