% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_numeros.R
\name{padronizar_numeros}
\alias{padronizar_numeros}
\title{Padronizar números de logradouros}
\usage{
padronizar_numeros(numeros)
}
\arguments{
\item{numeros}{Um vetor de caracteres ou números. Os números de logradouro a
serem padronizados.}
}
\value{
Um vetor de caracteres com os números de logradouros padronizados.
}
\description{
Padroniza um vetor de caracteres ou números representando números de
logradouros. Veja a seção \emph{Detalhes} para mais informações sobre a
padronização.
}
\section{Detalhes}{

Operações realizadas durante a padronização:
\itemize{
\item conversão para caracter, se o input for numérico;
\item remoção de espaços em branco antes e depois dos números e de espaços em
branco em excesso entre números;
\item remoção de zeros à esquerda;
\item substituição de números vazios e de variações de SN (SN, S N, S.N., S./N.,
etc) por S/N.
}
}

\examples{
numeros <- c("0210", "001", "1", "", "S N", "S/N", "SN", "0180  0181")
padronizar_numeros(numeros)

numeros <- c(210, 1, 10000, NA)
padronizar_numeros(numeros)

}
