% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold_partition.R
\name{kfold_partition}
\alias{kfold_partition}
\title{K-fold data partitioning}
\usage{
kfold_partition(data, dependent, k = 2, seed = 1)
}
\arguments{
\item{data}{data.frame or matrix containing at least two columns.}

\item{dependent}{(character) name of column that contains the
presence-absence records (1-0).}

\item{k}{(numeric) the number of groups that the given data is to be split
into.}

\item{seed}{(numeric) integer value to specify an initial seed. Default = 1.}
}
\value{
A list of vectors with the indices of rows corresponding to each fold.
}
\description{
Creates indices to partition available data into k equal-sized
subsets or folds, maintaining the global proportion of presence-absences
in each fold.
}
\examples{
# example data
data <- data.frame(species = c(rep(0, 80), rep (1,20)),
                   variable1 = rnorm(100),
                   variable2 = rpois(100, 2))

# create partition indices
kfolds <- kfold_partition(data, dependent = "species", k = 2)

# data for partition 1
data[kfolds$Fold_1, ]
}
