% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{getmr}
\alias{getmr}
\title{Get the mzrt profile and group information for batch correction and plot as a list directly from path with default setting}
\usage{
getmr(
  path,
  index = F,
  BPPARAM = BiocParallel::SnowParam(),
  pmethod = "hplcorbitrap",
  minfrac = 0.67,
  ...
)
}
\arguments{
\item{path}{the path to your data}

\item{index}{the index of the files}

\item{BPPARAM}{used for BiocParallel package}

\item{pmethod}{parameters used for different instrumentals such as 'hplcorbitrap', 'uplcorbitrap', 'hplcqtof', 'hplchqtof', 'uplcqtof', 'uplchqtof'. The parameters were from the references}

\item{minfrac}{minimum fraction of samples necessary in at least one of the sample groups for it to be a valid group, default 0.67}

\item{...}{arguments for xcmsSet function}
}
\value{
list with rtmz profile and group infomation
}
\description{
Get the mzrt profile and group information for batch correction and plot as a list directly from path with default setting
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file('cdf', package = 'faahKO')
list <- getmr(cdfpath, pmethod = ' ')
}
}
\seealso{
\code{\link{getdata}},\code{\link{getupload}}, \code{\link{getmzrt}}, \code{\link{getdoe}}
}
