% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifyFileStructure.R
\name{verifyFileStructure}
\alias{verifyFileStructure}
\title{Verify File Structure}
\usage{
verifyFileStructure(path, returnFileNames = TRUE, rasterExt = ".tif")
}
\arguments{
\item{path}{path to directory of rasters}

\item{returnFileNames}{logical, should file paths and names be returned}

\item{rasterExt}{file extension of rasters}
}
\value{
Prints messages to the console if problems are found. 
If \code{returnFileNames == TRUE}, then a vector of filenames is returned.
}
\description{
Ensures that the necessary files are present for other
functions to work properly.
}
\details{
This function searches for the following
in the directory specified by \code{path}:

19 bioclimatic variables named as bio_1.tif
	
12 precipitation rasters named as prec_1.tif

12 min temperature rasters named as tmin_1.tif

12 max temperature rasters named as tmax_1.tif

12 mean temperature rasters named as tmean_1.tif [optional]

12 solar radiation rasters named as et_solrad_1.tif

If mean temperature rasters are not detected, the raster creation functions
will create mean temperature by taking the mean of the min and max.
}
\examples{
# As there are no problems with these files, the list of files 
# will be returned.
verifyFileStructure(system.file('extdata', package='envirem'))
}
\author{
Pascal Title
}

