% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{extract_last_member}
\alias{extract_last_member}
\title{Extract the last member in a string representing an object}
\usage{
extract_last_member(full_name)
}
\arguments{
\item{full_name}{character scalar from which we should keep the piece that comes after the last \code{$} sign.}
}
\value{
A list with two members: \code{root} containing the path to the last name of the object expression
and \code{name}, containing the last name in the object expression.
The \code{root} is empty when there is no \code{$} in the input string.
Ex: \code{extract_last_member("obj$x$y")} returns \code{list(root="obj$x", name="y")}.
}
\description{
Function that extracts the last name in a string representing an object as in e.g. \code{obj$x$y}.
It returns a list containing both the piece before the last occurrence of \code{$} and the name coming after it.
The object may or may not exist.
}
\keyword{internal}

