% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{grubbs.detect}
\alias{grubbs.detect}
\title{Grubbs test based identification of outliers on segments - Only intended for developer use}
\usage{
grubbs.detect(x, cp.segment)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{cp.segment}{an integer membership vector for individual segments.}
}
\value{
A logical vector specifing the identified outliers, \code{TRUE} means that corresponding data value from vector \code{x} is detected as outlier.
}
\description{
Identification of outlier data values on individual homogeneous segments using Grubbs test.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function detects outlier observations on individual segments using Grubbs test.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for identification of outlier residuals.
}
\references{
Grubbs F (1950). Sample criteria for testing outlying observations. The Annals of Mathematical Statistics, 21(1), 27-58.

Campulova M, Michalek J, Mikuska P, Bokal D (2018). Nonparametric algorithm for identification of outliers in environmental data. Journal of Chemometrics, 32, 453-463.
}
