% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_poverty.R
\name{calculate_poverty}
\alias{calculate_poverty}
\title{Calculo de Pobreza e Indigencia}
\usage{
calculate_poverty(base, basket, print_summary = TRUE)
}
\arguments{
\item{base}{Base individual de uno o más períodos}

\item{basket}{basket basica alimentaria y total, con la siguiente estructura:
# A tibble: N x 5
  region    periodo   CBA   CBT codigo
  <chr>     <chr>   <dbl> <dbl>  <dbl>
1 Cuyo      2016.3  1509. 3872.     42
2 Cuyo      2016.4  1570. 4030.     42
3 GBA       2016.3  1684. 4053.      1
. ...      .....   .....   ....    ...}

\item{print_summary}{TRUE/FALSE, opcion para imprimir las tasas de pobreza e indigencia}
}
\description{
Función para calcular la pobreza e indigencia siguiendo la metodología de línea.
}
\details{
#'disclaimer: El script no es un producto oficial de INDEC.
}
\examples{

#'
bases <- dplyr::bind_rows(toybase_individual_2016_03,toybase_individual_2016_04)
base_pobreza <- calculate_poverty(base = bases, basket = canastas_reg_example,print_summary=TRUE)

}
