% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_agglomerates.R
\name{map_agglomerates}
\alias{map_agglomerates}
\title{Mapa de indicadores por aglomerado}
\usage{
map_agglomerates(
  .data,
  agglomerates,
  indicator,
  alpha = 0.75,
  palette = "viridis"
)
}
\arguments{
\item{.data}{Dataframe con los datos}

\item{agglomerates}{Variable con los codigos de aglomerados}

\item{indicator}{Variable con los indicadores}

\item{alpha}{Opacidad de los puntos}

\item{palette}{Paleta de colores a utilizar, incluye "viridis", "magma", "inferno", or "plasma". Para mas opciones, ver \link[leaflet]{colorNumeric}}
}
\value{
Devuelve un mapa de indicadores por aglomerado
}
\description{
Mapa de indicadores por aglomerado
}
\examples{

toybase_individual_2016_04 \%>\%
  dplyr::group_by(AGLOMERADO) \%>\%
  dplyr::summarise(tasa_actividad = sum(PONDERA[ESTADO == 1]) / sum(PONDERA)) \%>\%
  map_agglomerates(
    agglomerates = AGLOMERADO,
    indicator = tasa_actividad
  )
}
