% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{stabilityBIG}
\alias{stabilityBIG}
\title{Computes the area under the stability path for all covariates}
\usage{
stabilityBIG(X, Y, family = "gaussian", n_subsample = 20,
  n_lambda = 100, lambda_min_ratio = 0.01, eps = 1e-05,
  short = TRUE, ncores = 2)
}
\arguments{
\item{X}{design matrix formatted as a
\code{\link[bigmemory]{big.matrix}} object}

\item{Y}{response vector}

\item{family}{response type. Either 'gaussian' or 'binomial'}

\item{n_subsample}{number of subsamples for stability selection}

\item{n_lambda}{total number of lambda values}

\item{lambda_min_ratio}{the minimum value of the regularization
parameter lambda as a fraction of the maximum lambda, the first
value for which the elastic net support is not empty.}

\item{eps}{elastic net mixing parameter (see \code{\link{stabilityGLM}}
for more details)}

\item{short}{whether to compute the aucs only on the first half
of the stability path. We observed better performance with
thresholded paths}

\item{ncores}{number of cores for the
\code{\link[biglasso]{biglasso}} solver}
}
\value{
a vector grouping the aucs of all covariates within \code{X}
}
\description{
This function implements the same model selection technique extensively
described in \code{\link{stabilityGLM}}. The sole difference is the use
of a different elastic net solver. In this function, we make use of
\code{\link[biglasso]{biglasso}}. Thanks to its parallel
backend, \code{biglasso} scales well to
high-dimensional GWAS datasets. However, in our case, because of the use of
additional backend files, a slight decrease in runtime is to be expected,
compared with \code{\link{stabilityGLM}}.
}
\examples{
n <- 100
p <- 25
X <- bigmemory::as.big.matrix(matrix(runif(n * p), ncol = p))
Y <- runif(n, min = 0, max = 1) < 0.5
aucBIG <- stabilityBIG(X, Y,
  family = "binomial", short = TRUE,
  ncores = 1, n_lambda = 200, n_subsample = 1
)
}
\references{
Slim, L., Chatelain, C., Azencott, C.-A., & Vert, J.-P.
(2018). Novel Methods for Epistasis Detection in Genome-Wide Association
Studies. BioRxiv.

Meinshausen, N., & Bühlmann, P. (2010). Stability
selection. Journal of the Royal Statistical Society: Series B
(Statistical Methodology), 72(4), 417–473.

Haury, A. C., Mordelet, F., Vera-Licona, P., & Vert, J. P.
(2012). TIGRESS: Trustful Inference of Gene REgulation using Stability
Selection. BMC Systems Biology, 6.
}
\seealso{
\code{\link[biglasso]{biglasso-package}}

Other support estimation functions: \code{\link{stabilityGLM}}
}
\concept{support estimation functions}
