% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pvt_twitter}
\alias{pvt_twitter}
\title{HealthTweets total and influenza-related tweets}
\usage{
pvt_twitter(
  auth,
  locations,
  ...,
  time_type = c("day", "week"),
  time_values = "*",
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{auth}{string. Restricted access key (not the same as API key).}

\item{locations}{character. Locations to fetch.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{time_type}{string. The temporal resolution of the data (either "day" or
"week", depending on signal).}

\item{time_values}{\code{\link{timeset}}. Dates or epiweeks to fetch. Defaults to all
("*") dates.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/twitter.html}

This is the API documentation for accessing the Twitter Stream endpoint of
Delphi’s epidemiological data. Sourced from
\href{http://www.healthtweets.org/}{Healthtweets}
}
\examples{
\dontrun{
pvt_twitter(
  auth = Sys.getenv("SECRET_API_AUTH_TWITTER"),
  locations = "CA",
  time_type = "week",
  time_values = epirange(201501, 202001)
)
}
}
\keyword{endpoint}
