% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getInteraction}
\alias{getInteraction}
\title{Retrieve interaction values.}
\usage{
getInteraction(pop, n)
}
\arguments{
\item{pop}{a valid population object}

\item{n}{the interaction to return}
}
\description{
Retrieve  values for an interaction within an epistatic network.
}
\details{
This function returns a \eqn{k}-dimensional array for a particular
interaction, where \eqn{k} is the order of interaction and the
array holds \eqn{3^k} entries . This means that a 5-way
interaction, for example, will return a 5-dimensional array
consisting of \eqn{3^5 = 243} entries.

Within each dimension, the three indices (1, 2 and 3) correspond
to the homozygous genotype coded 0/0, the heterozygous genotype
and the homozygous genotype coded 1/1, respectively. Each entry
is drawn from a normal distribution. (Any offset needs to be
applied manually using \code{getEpiOffset}.)
}
\examples{
# Construct a new population
pop <- Population(
  popSize = 150, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100), broadH2 = 0.7,
  narrowh2 = 0.45, traitVar = 40
)

# Attach additive effects
pop <- addEffects(pop)

# Attach a network of epistatic effects
pop <- attachEpiNet(pop)

# Retrieve the possible values for the first two-way interaction
getInteraction(pop, 1)

# Retrieve the value for the case where, in the fourth two-way
# interaction, the first QTL in the interaction is heterozygous
# and the second QTL in the interaction is the homozygous
# reference genotype.
getInteraction(pop, 4)[2, 1]

# Retrieve the value for the case where, in the second two-way
# interaction, the first QTL in the interaction is the homozygous
# reference genotype and the second QTL in the interaction is the
# homozygous alternative genotype.
getInteraction(pop, 2)[1, 3]
}
\seealso{
\code{\link{attachEpiNet}}, \code{\link{getEpiOffset}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
