% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_by.R
\name{freq_by}
\alias{freq_by}
\title{Frequencies and percentages}
\usage{
freq_by(dataset, var_vector, by_group = NULL, include_total = TRUE,
  htmlout = TRUE)
}
\arguments{
\item{dataset}{A dataset}

\item{var_vector}{A character vector containing names of the columns in the
input dataset to calculate frequencies and percentages for.}

\item{by_group}{A string referring to a factor column in the input dataset
by which to stratify the calculations.}

\item{include_total}{whether to include frequencies and percentages not
stratified by the \code{by_group}.}

\item{htmlout}{Whether to output to html (default and intended usage), or
as r-dataframe.}
}
\description{
\code{freq_by} creates frequency and percentage tables in HTML.
}
\details{
The output is a table in HTML which can be viewed in a browser or
included in a knitr-report.
}
\examples{
# Outputs HTML:
output <- freq_by(example_data, c("cut", "color"), "clarity")
}
